//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "Unit2.h"
#include "Unit3.h"
#include "inifiles.hpp"
#include "NewItems.h"
#include "VisasmConfig.h"
#include "ToolConfigForm1.h"
#include "CompilerConfig.h"
#include "CmdLineForm.h"
#include "ContribFrm.h"
#include "FileFindForm1.h"
#include "FileCompareForm1.h"
#include "projman.h"
#include "scrf.hpp"
#include "AsmWiz1.h"

//---------------------------------------------------------------------------
#pragma link "tbedit"
#pragma resource "*.dfm"
TForm1 *Form1;




//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------


///   ***************************************************** ///
///   Form Methods  -- Auto Created Programs By the BCB IDE ///
///   ***************************************************** ///
///   FormCreate, FormShow, FormClose						///

//---------------------------------------------------------------------------


void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
  SaveSplitterLocation();
  SaveButtonsToIni();
  for (int i=0; i<ComponentCount; i++)
  {
    if (Components[i]->ClassNameIs("TForm2"))
    {
      TForm2* DeleteForm = (TForm2*) Components[i];
      delete DeleteForm;
    }


  }

}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
///   *****************************************************    ///
///   Custom Form Procedures -- Done By the+Intern             ///
///   *****************************************************    ///
///   OnGetMinMaxInfo , LoadButtonsFromIni, SaveButtonsToIni   ///
///      LoadSplitterLocation, SaveSplitterLocation			   ///


/// This procedure handles the message WM_GETMINMAXINFO		///
/// the max, min window size, min, max window position can  ///
/// be set with handling this message	    				///

void __fastcall TForm1::OnGetMinMaxInfo(TWMGetMinMaxInfo& Message)
{
  // Maximum Window Size = screenwidth, 100
  Message.MinMaxInfo->ptMaxTrackSize = Point( Screen->Width,110);
  Message.Result = 0;
}
//---------------------------------------------------------------


///   ***************************************************** ///
/// LoadButtonsFromIni() This procedure is called typically at ///
/// Startup to load the button coordinates from the ini file   ///
/// of the buttons on the toolbar.							   ///
///   ***************************************************** ///

int __fastcall TForm1::LoadButtonsFromIni()
{
  TSpeedButton* Btn ;
  AnsiString CurrentToolbarItem, ButtonDescription;

  if (FileExists((ExtractFilePath(Application->ExeName) + "Buttons.ini")))
  {
    TIniFile* IniFile = new TIniFile((ExtractFilePath(Application->ExeName) + "Buttons.ini"));
      try
      {
        // Remove all buttons
      	for(int i =0; i< TBE->ItemCount; i++)
    	{
          if (TBE->Items[i]->Button !=0)
      	  {
            TBE->Items[i]->Button->Free();
      		TBE->Items[i]->Button = 0 ;
          }
        }
      // Add the buttons.
      for (int i=0; i< TBE->ItemCount; i++)
      {
        CurrentToolbarItem = TBE->Items[i]->Name; // get the itemname to use in the inifile section
        // try reading description of the current toolbar item.
        // if the current toolbaritem does not appear in the ini file
        // the description will be set to empty.
        ButtonDescription  = IniFile->ReadString(CurrentToolbarItem, "Description", "");
        if (ButtonDescription == "") continue; // no description = no creation
        else
        {
          Btn       = TBE->Items[i]->CreateButton(TBE->Toolbar);
          Btn->Top  = IniFile->ReadInteger(CurrentToolbarItem, "ButtonTop", 0);
          Btn->Left = IniFile->ReadInteger(CurrentToolbarItem, "ButtonLeft", 0);
          Btn->Visible = IniFile->ReadBool(CurrentToolbarItem, "Visible", 0);
          Btn->Enabled = IniFile->ReadBool(CurrentToolbarItem, "Enabled", 0);
        }
      }
    }
    catch ( ... )
    {
      IniFile->Free();
      Application->MessageBox("Exception occured while loading button coordinates from inifile",
                            "LoadButtonsFromIni Exception", MB_OK|MB_ICONWARNING	);
    }
    IniFile->Free();
    return 1;
  }
  else return 0;
}


///   ***************************************************** ///
/// SaveButtonsToIni()  This procedure is called typically  	///
/// before closing the application. This procedure saves    	///
/// the coordinates of the toolbarbuttons into the inifile  	///
/// First the old inifile is cleared then the new one is written///
///   ***************************************************** ///

void __fastcall TForm1::SaveButtonsToIni()
{  // clear the existing inifile
  TStringList* IniList = new TStringList();
  try
  {
    IniList->Clear();
    IniList->SaveToFile((ExtractFilePath(Application->ExeName)) + "Buttons.ini");
  }
  catch ( ... )
  {
    Application->MessageBox("Hmmm... problem deleting inifile !","ClearInifile problem", MB_OK|MB_ICONWARNING	);
  }
  IniList->Free();
  Application->ProcessMessages();
  // anyone know a better way to clear this file ??? ideas welcome !


  AnsiString str, Section;
  TIniFile* IniFile = new TIniFile((ExtractFilePath(Application->ExeName) + "Buttons.ini"));
  try
  {
    for (int i = 0; i< TBE->ItemCount ; i++)
    {
      TToolbarButton* Btn = dynamic_cast<TToolbarButton*>(TBE->Items[i]->Button);
      if (Btn)
      {
        Section = TBE->Items[i]->Name;
        IniFile->WriteString(Section, "Description", TBE->Items[i]->Description);
        IniFile->WriteInteger(Section, "ButtonTop", Btn->Top);
        IniFile->WriteInteger(Section, "ButtonLeft", Btn->Left);
        IniFile->WriteBool(Section, "Visible", Btn->Visible);
        IniFile->WriteBool(Section, "Enabled", Btn->Enabled);
      }
    }
  }
  catch ( ... )
  {
    IniFile->Free();
  	Application->MessageBox("Exception occured while saving button coordinates to inifile",
                            "SaveButtonsToIni Exception", MB_OK|MB_ICONWARNING	);
  }
  IniFile->Free();
}


///   ***************************************************** ///
/// LoadSplitterLocation() This procedure is called along with    ///
/// the loadbuttons procedure to determine the pos of the toolbar ///
/// panel.														  ///
///   ***************************************************** ///

int __fastcall TForm1::LoadSplitterLocation()
{
  if (FileExists((ExtractFilePath(Application->ExeName) + "Splitter.ini")) )
  {
  TIniFile* IniFile = new TIniFile((ExtractFilePath(Application->ExeName) + "Splitter.ini"));
  try
  {
    ToolbarPanel->Width = IniFile->ReadInteger("Toolbar", "ToolbarWidth", 190);
    FOldPanelWidth = ToolbarPanel->Width;
  }
  catch ( ... )
  {
    IniFile->Free();
  	Application->MessageBox("Exception occured while loading splitter coordinates from inifile",
                            "LoadSplitterFromIni Exception", MB_OK|MB_ICONWARNING	);
  }
  IniFile->Free();
  return 1; // everything is ok
}
else return 0; // no inifile
}


///   ***************************************************** ///
/// SaveSplitterLocation() This procedure is called along with    ///
/// the Savebuttons procedure to save the pos of the toolbar      ///
/// panel.														  ///
///   ***************************************************** ///

void __fastcall TForm1::SaveSplitterLocation()
{
  TIniFile* IniFile = new TIniFile((ExtractFilePath(Application->ExeName) + "Splitter.ini"));
  try
  {
    IniFile->WriteInteger("Toolbar", "ToolbarWidth", ToolbarPanel->Width);
  }
  catch ( ... )
  {
    IniFile->Free();
  	Application->MessageBox("Exception occured while saving Splitter coordinates to inifile",
                            "SaveSplitterToIni Exception", MB_OK|MB_ICONWARNING	);
  }
  IniFile->Free();
}






///   ***************************************************** ///
///   File Menu Items Procedures 							///
///   Auto Created By the BCB IDE 					///
///   ***************************************************** ///
///   File_--------						///
///   Edit_--------
///   Search_------
///   View_--------
///   Help_About


/// ****************************************************************///
/// ************    File_--------  Functions    *******************///
/// ****************************************************************///
//---------------------------------------------------------------------------
void __fastcall TForm1::Properties1Click(TObject *Sender)
{
TBE->Edit();
}

void __fastcall TForm1::File_NewUnitClick(TObject *Sender)
{
  Form2->NewTab();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::File_OpenClick(TObject *Sender)
{
  Form2->FileOpen();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::File_SaveClick(TObject *Sender)
{
  Form2->FileSave();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::File_SaveAsClick(TObject *Sender)
{
  Form2->FileSaveAs();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::File_SaveAllClick(TObject *Sender)
{
  Form2->FileSaveAll();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::File_CloseClick(TObject *Sender)
{
  Form2->FileClose();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::File_CloseAllClick(TObject *Sender)
{
  Form2->FileCloseAll();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::File_PrintClick(TObject *Sender)
{
  Form2->FilePrint();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::File_ExitClick(TObject *Sender)
{
  Close();
}
//---------------------------------------------------------------------------


/// ****************************************************************///
/// ************    Edit_--------  Functions    *******************///
/// ****************************************************************///

void __fastcall TForm1::Edit_UndoClick(TObject *Sender)
{
  Form2->Undo();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Edit_RedoClick(TObject *Sender)
{
  //Form2->Redo(); // not functional yet
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Edit_CutClick(TObject *Sender)
{
  Form2->Cut();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Edit_CopyClick(TObject *Sender)
{
  Form2->Copy();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Edit_PasteClick(TObject *Sender)
{
  Form2->Paste();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Edit_DeleteClick(TObject *Sender)
{
  Form2->Delete(); // not functional yet
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Edit_SelectAllClick(TObject *Sender)
{
  Form2->SelectAll();
}
//---------------------------------------------------------------------------




/// ****************************************************************///
/// ************    View_--------  Functions    *******************///
/// ****************************************************************///

void __fastcall TForm1::View_EditorWindowClick(TObject *Sender)
{
  bool ShowEditorWindow = View_EditorWindow->Checked;
  View_EditorWindow->Checked = !ShowEditorWindow;
  Form2->Visible = !ShowEditorWindow;

}
//---------------------------------------------------------------------------




void __fastcall TForm1::View_ComponentPaletteClick(TObject *Sender)
{


  TMenuItem* mnu = dynamic_cast<TMenuItem*>(Sender);
  if (mnu)
  {
    mnu->Checked = !mnu->Checked;
    if (mnu->Caption == "Toolbar")
    {
      ToolbarPanel->Visible = mnu->Checked;
    }
    else
    {
      PalettePanel->Visible = mnu->Checked;
      if (mnu->Checked)
      {
        ToolbarPanel->Align = alLeft;
        ToolbarPanel->Width = FOldPanelWidth;
      }

    }
  }

  Panel1->Visible = PalettePanel->Visible | ToolbarPanel->Visible ;
  if (Panel1->Visible)
  {
    ClientHeight = 500;
    View_NoWhistles->Checked = false;
  }
  else
  {
    ClientHeight = 0;
    View_NoWhistles->Checked = true;
  }


  SplitPanel->Visible = PalettePanel->Visible & ToolbarPanel->Visible ;
  if (SplitPanel->Visible)
  {
    if (ToolbarPanel->Align == alLeft)
    {
      SplitPanel->Left = ToolbarPanel->Width;
    }
  }
  else if (ToolbarPanel->Visible)
  {
    if (ToolbarPanel->Align == alLeft)
    {
      FOldPanelWidth = ToolbarPanel->Width;
      ToolbarPanel->Align =alClient;
    }
  }


}

//---------------------------------------------------------------------------

void __fastcall TForm1::View_NoWhistlesClick(TObject *Sender)
{
  bool NoWhistles = !View_NoWhistles->Checked;
  Form3->Visible  = !NoWhistles;
  Panel1->Visible = !NoWhistles;
  if (NoWhistles)
  {
    FOldHeight = ClientHeight;  			// Save the height of the mainwindow
    int i = ClientHeight;					// let's do some nice animation !
    while (i > 0)
    {
      i = i -1;        						// slide up by one pixel
      // if (i<0) i = 0;
      ClientHeight = i;
      Application->ProcessMessages();		// give old windows some time
    }                                       // animation is done

    Form2->WindowState = wsMaximized;
  }
  else  									// let's put all windows back
  {
    Form2->WindowState = wsNormal;
    int i = 0;
    while (i<FOldHeight)
    {
      i = i+1;
      // if (i<ClientHeight) i = ClientHeight;  // some safety in case not increm by 1
      ClientHeight = i;
      Application->ProcessMessages();
    }
  }

  Form2->Top = Height;					// put the editor window under the main

  View_NoWhistles->Checked = NoWhistles;

}
//---------------------------------------------------------------------------

void __fastcall TForm1::View_NewEditorWindowClick(TObject *Sender)
{
  TForm2* NewEditWindow;
  Application->CreateForm(__classid(TForm2), &NewEditWindow);
  NewEditWindow->PutEditorWindow(Height);
  NewEditWindow->Show();
  // here some features of loading the current file into the editor.
  // and eventually a dde server client item for continues updating
  // between the two edit windows.

  // This way no memory leak. THe application component frees the form
  // You don't have to take care of it. Want to test it ?
  // create 40 new editwindows. Take a look at your free user resources.
  // close them all or close the program. All resources are given back :-)
}
//---------------------------------------------------------------------------


/// ****************************************************************///
/// ************    Search_--------  Functions    *******************///
/// ****************************************************************///



void __fastcall TForm1::Search_FindClick(TObject *Sender)
{
  Form2->Find();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Search_ReplaceClick(TObject *Sender)
{
  Form2->Replace();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Search_FileFindClick(TObject *Sender)
{
    FileFindForm->Show();
}
//---------------------------------------------------------------------------


/// ****************************************************************///
/// ************    Help_--------  Functions    *******************///
/// ****************************************************************///

void __fastcall TForm1::Help_AboutClick(TObject *Sender)
{
Application->MessageBox("IDE interface for Visual Assembler+.  Done by The+Intern",
   						"Aboutbox", MB_OK|MB_ICONINFORMATION);
}


//***************************************************************************
//******                                                               ******
//******                      IMPORTED FUNCTIONS                       ******
//******                      Done by Mammon / +ReZiDeNt               ******
//***************************************************************************
//---------------------------------------------------------------------------



int __fastcall TForm1::StartUpInfo()
{

AnsiString AppPath = ExtractFilePath(Application->ExeName);
if (FileExists(ChangeFileExt(ParamStr(0),".INI")))
{
TIniFile* IniFile = new TIniFile( ChangeFileExt(ParamStr(0),".INI"));
try
{
  //Set up Assembler Defaults
  AssemblerInfo.Assembler = IniFile->ReadString( "Defaults", "Assembler", "TASM");
  AssemblerInfo.CPU = IniFile->ReadString( "Defaults", "CPU", "386");
  AssemblerInfo.Platform = IniFile->ReadString( "Defaults", "Platform", "Win32");

  //Set up paths
  DirInfo.BasePath = IniFile->ReadString( "Main", "Install", AppPath );
  DirInfo.ProjectPath = IniFile->ReadString( "Main", "Projects", DirInfo.BasePath + "\Projects");
  DirInfo.ModulePath = IniFile->ReadString( "Main", "Modules", DirInfo.BasePath + "\Modules");
  ProjectInfo.ProjectOpen = FALSE;

  DirInfo.APIPath = IniFile->ReadString( "Defaults", "API", DirInfo.ModulePath + "\API");
  DirInfo.ASMPath = IniFile->ReadString( "Defaults", "ASM", DirInfo.ModulePath + "\ASM");
  DirInfo.CPath = IniFile->ReadString( "Defaults", "C", DirInfo.ModulePath + "\C");
  DirInfo.IntPath = IniFile->ReadString( "Defaults", "Int", DirInfo.ModulePath + "\Int");
  DirInfo.LibraryPath = IniFile->ReadString( "Defaults", "Library", DirInfo.ModulePath + "\Library");
  DirInfo.OpcodePath = IniFile->ReadString( "Defaults", "Opcodes", DirInfo.ModulePath + "\Opcodes");

  //Integrated Tools Initialization
  // Hmmmm. this makes no sense ! integral tools and external tools mixed up
  // under the initialization of the integrated tools ???
  // btw the resource editor is never written to the inifile. you can't set it, yet :-)

  Tools.Calc = IniFile->ReadString( "External Tools", "Calculator",DirInfo.BasePath + "\Tools\\Calc\\calc.exe");
  Tools.Text = IniFile->ReadString( "External Tools", "TextEditor",DirInfo.BasePath + "\Tools\\Text\\vatt.exe");
  Tools.Hex = IniFile->ReadString( "External Tools", "HexEditor",DirInfo.BasePath + "\Tools\\Hex\\hex.exe");

  //To clarify...the above tools are meant to be set by the user
  //the below tools are not as they will eventually interact with
  //the IDE and the wizards to quite an extent...  _m
  Tools.Res = IniFile->ReadString( "Integrated Tools", "Res",DirInfo.BasePath + "\Tools\\Resedit\\Resedit.exe");
  Tools.Browse = IniFile->ReadString( "Integrated Tools", "Browser",DirInfo.BasePath + "\Tools\\Browser\\Vapb.exe");
  Tools.Dump = IniFile->ReadString( "Integrated Tools", "Dump",DirInfo.BasePath + "\Tools\\Dump\\Dumpbin.exe");
  Tools.Debug = IniFile->ReadString( "Integrated Tools", "Debug",DirInfo.BasePath + "\Tools\\Debug\\nwdebug.exe");
  Tools.Dis = IniFile->ReadString( "Integrated Tools", "Dis",DirInfo.BasePath + "\Tools\\Dis\\Dis.com");

  //Setup Assembler
  LoadAssemblerVals();
 }
 catch ( ... )
 {
   IniFile->Free();
   Application->MessageBox("Exception occured while reading the application settings",
                            "Application Exception", MB_OK|MB_ICONWARNING);
   DirInfo.BasePath = ParamStr(0);
 }
 IniFile->Free();
 //set up a few string lists
 ProjectInfo.AsmFiles = new TStringList;
 ProjectInfo.IncFiles = new TStringList;
 ProjectInfo.RcFiles = new TStringList;
 ProjectInfo.ProjectOpen = FALSE;
 return 1; // inifile OK !
}
else
{
  return 0; // no inifile in directory.
}
}


void __fastcall TForm1::RegisterNewUser()
{
  TVisAsmConfigForm* VisAsmConfigForm = new TVisAsmConfigForm(this);
  try
  {
    VisAsmConfigForm->ShowModal();
    //if (AssemblerInfo.Assembler=="") CompilerConfigForm->Show();
    //if (Tools.Text=="") ToolConfigForm->Show();
  /* if (Tools.Calc =="")Tools.Calc =  Form1->DirInfo.BasePath + "\Tools\\Calc\\Calc.exe";
  if (Tools.Text =="")Tools.Text =  Form1->DirInfo.BasePath + "\Tools\\Text\\Vatt.exe";
  if (Tools.Res =="")Tools.Res =   Form1->DirInfo.BasePath + "\Tools\\Resedit\\Resedit.exe";
  if (Tools.Dump =="")Tools.Dump =  Form1->DirInfo.BasePath + "\Tools\\Dump\\Dumpbin.exe";
  if (Tools.Debug =="")Tools.Debug  =  Form1->DirInfo.BasePath + "\Tools\\Debug\\nwdebug.exe";
  if (Tools.Dis =="")Tools.Dis =  Form1->DirInfo.BasePath + "\Tools\\Dis\\Dis.com";
  if (Tools.Hex =="")Tools.Hex =  Form1->DirInfo.BasePath + "\Tools\\Hex\\Hexedit.exe";
  if (Tools.Browse =="")Tools.Browse = Form1->DirInfo.BasePath + "\Tools\\Browser\\Vapb.exe"; */
  }
  catch ( ... )
  {
    delete VisAsmConfigForm;
    throw;
  }
  delete VisAsmConfigForm;
}


//****************************************************************************
//******                 Generic Functions                              ******
//****************************************************************************
// ToolExecute


void __fastcall TForm1::ToolExecute( AnsiString ToolType, AnsiString ToolName)
{
AnsiString FileName, Target;
TIniFile* IniFile = new TIniFile( ChangeFileExt(ParamStr(0),".INI"));
try
{
  FileName = IniFile->ReadString(ToolType, ToolName, "");

/*
  if (IniFile->ReadString( ToolType, ToolName + "FileName", "TRUE") == "TRUE")
  {
    if (FileOpenDlg->Execute()) Target = FileOpenDlg->FileName;
  }

*/

  if(FileName != "")ShellExecute(NULL, "open", FileName.c_str(), Target.c_str(), NULL, SW_SHOWNORMAL);
}
catch( ... )
{
  IniFile->Free();
  throw;
}
  IniFile->Free();
}



//****************************************************************************
//******                    Tools Menu                                  ******
//****************************************************************************





void __fastcall TForm1::Tools_ConfigureToolsClick(TObject *Sender)
{
  TToolConfigForm* ToolConfigForm = new TToolConfigForm(this);
  try
  {
    ToolConfigForm->ShowModal();
  }
  catch ( ... )
  {
    delete ToolConfigForm;
    throw;
  }
  delete ToolConfigForm;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Options_ConfigureAssemblerClick(TObject *Sender)
{
  TCompilerConfigForm *CompilerConfigForm = new TCompilerConfigForm(this);
  try
  {
    CompilerConfigForm->ShowModal();
  }
  catch ( ... )
  {
    delete CompilerConfigForm;
    throw;
  }
  delete CompilerConfigForm;

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Run_CommandLineClick(TObject *Sender)
{
  ExecutableCmdForm->RedirectOutput = FALSE;
  ExecutableCmdForm->Show();

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Run_CompileClick(TObject *Sender)
{
    ExecutableCmdForm->RedirectOutput = TRUE;
    if (! Form2->MessageEdit->Visible )
      {
        View_MessageWindowClick(this);
      }

    TIniFile* IniFile = new TIniFile( DirInfo.BasePath + "\Compilers.ini");
    try
    {
      ExecutableCmdForm->InsertCommandLine = IniFile->ReadString(AssemblerInfo.Assembler, "CompilePath", "");
      ExecutableCmdForm->InsertArgs = IniFile->ReadString(AssemblerInfo.Assembler, "CompileArgs", "");
      ExecutableCmdForm->Show();
      //VisualAsmMain->MessageEdit->SetSelTextBuf(char * Buffer);
    }
    catch( ... )
    {
      IniFile->Free();
      throw;
    }
    IniFile->Free();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Run_LinkClick(TObject *Sender)
{
	ExecutableCmdForm->RedirectOutput = TRUE;

    ExecutableCmdForm->RedirectOutput = TRUE;
    if (! Form2->MessageEdit->Visible)
      {
        View_MessageWindowClick(this);
      }

    TIniFile* IniFile = new TIniFile( DirInfo.BasePath + "\Compilers.ini");
    try
    {
      ExecutableCmdForm->InsertCommandLine = IniFile->ReadString(AssemblerInfo.Assembler, "LinkPath", "");
      ExecutableCmdForm->InsertArgs = IniFile->ReadString(AssemblerInfo.Assembler, "LinkArgs", "");
	  ExecutableCmdForm->Show();
    }
    catch( ... )
    {
      IniFile->Free();
      throw;
    }
    IniFile->Free();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Run_MakeClick(TObject *Sender)
{
	ExecutableCmdForm->RedirectOutput = TRUE;
    ExecutableCmdForm->RedirectOutput = TRUE;

    if (! Form2->MessageEdit->Visible )
      {
        View_MessageWindowClick(this);
      }

    TIniFile* IniFile = new TIniFile( DirInfo.BasePath + "\Compilers.ini");
    try
	{
      ExecutableCmdForm->InsertCommandLine = IniFile->ReadString(AssemblerInfo.Assembler, "MakePath", "");
      ExecutableCmdForm->InsertArgs = IniFile->ReadString(AssemblerInfo.Assembler, "MakeArgs", "");
      ExecutableCmdForm->Show();
    }
    catch( ... )
    {
      IniFile->Free();
      throw;
    }
    IniFile->Free();

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Tools_CalculatorClick(TObject *Sender)
{
 ShellExecute(NULL, "open", Tools.Calc.c_str(), NULL, NULL, SW_SHOWNORMAL);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Tools_HexEditorClick(TObject *Sender)
{
  AnsiString Target = "";
  ShellExecute(NULL, "open", Tools.Hex.c_str(), Target.c_str(), NULL, SW_SHOWNORMAL);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Tools_TextEditorClick(TObject *Sender)
{
  AnsiString Target = "";
  ShellExecute(NULL, "open", Tools.Text.c_str(), Target.c_str(), NULL, SW_SHOWNORMAL) ;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Tools_ResourceEditorClick(TObject *Sender)
{
  AnsiString Target;
//  if (FileOpenDlg->Execute()){Target += FileOpenDlg->FileName;}
  ShellExecute(NULL, "open", Tools.Res.c_str(), Target.c_str(), NULL, SW_SHOWNORMAL);
}
//---------------------------------------------------------------------------


void __fastcall TForm1::Tools_Dumpbin_AllClick(TObject *Sender)
{
  AnsiString Target, RunDir;
  RunDir = DirInfo.BasePath + "/Tools/Dump";
  if (FileOpenDlg->Execute()){Target = "/ALL /OUT:dump_out.txt " + FileOpenDlg->FileName;}

  ShellExecute(NULL, "open", Tools.Dump.c_str(), Target.c_str(), RunDir.c_str(), SW_HIDE);
  Target = RunDir + "/dump_out.txt";
  SleepEx( 0x00001FFF, FALSE);

  ShellExecute(NULL, "open", Tools.Text.c_str(), Target.c_str(), NULL, SW_SHOWNORMAL) ;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Tools_Dumpbin_SummaryClick(TObject *Sender)
{
  AnsiString Target;
  AnsiString RunDir = DirInfo.BasePath + "/Tools/Dump";
  if (FileOpenDlg->Execute()){
    Target = "/SUMMARY /OUT:dump_out.txt " + FileOpenDlg->FileName;}

  ShellExecute(NULL, "open", Tools.Dump.c_str(), Target.c_str(), RunDir.c_str(), SW_HIDE);

  Target = RunDir + "/dump_out.txt";
  SleepEx( 0x00000FFF, FALSE);

  ShellExecute(NULL, "open", Tools.Text.c_str(), Target.c_str(), NULL, SW_SHOWNORMAL) ;
}

//---------------------------------------------------------------------------
void __fastcall TForm1::Tools_Dumpbin_dataClick(TObject *Sender)
{
  AnsiString Target;
  AnsiString RunDir = DirInfo.BasePath + "/Tools/Dump";
  if (FileOpenDlg->Execute()){Target = "/SECTION:.data /OUT:dump_out.txt " + FileOpenDlg->FileName;}

  ShellExecute(NULL, "open", Tools.Dump.c_str(), Target.c_str(), RunDir.c_str(), SW_HIDE);

  Target = RunDir + "/dump_out.txt";
  SleepEx( 0x00000FFF, FALSE);

  ShellExecute(NULL, "open", Tools.Text.c_str(), Target.c_str(), NULL, SW_SHOWNORMAL) ;

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Tools_Dumpbin_rsrcClick(TObject *Sender)
{
  AnsiString Target;
  AnsiString RunDir = DirInfo.BasePath + "/Tools/Dump";
  if (FileOpenDlg->Execute()){Target = "/SECTION:.rsrc /OUT:dump_out.txt " + FileOpenDlg->FileName;}

  ShellExecute(NULL, "open", Tools.Dump.c_str(), Target.c_str(), RunDir.c_str(), SW_HIDE);

  Target = RunDir + "/dump_out.txt";
  SleepEx( 0x00000FFF, FALSE);

  ShellExecute(NULL, "open", Tools.Text.c_str(), Target.c_str(), NULL, SW_SHOWNORMAL) ;

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Tools_Dumpbin_textClick(TObject *Sender)
{
  AnsiString Target;
  AnsiString RunDir = DirInfo.BasePath + "/Tools/Dump";
  if (FileOpenDlg->Execute()){Target = "/SECTION:.text /OUT:dump_out.txt " + FileOpenDlg->FileName;}

  ShellExecute(NULL, "open", Tools.Dump.c_str(), Target.c_str(), RunDir.c_str(), SW_HIDE);

  Target = RunDir + "/dump_out.txt";
  SleepEx( 0x00000FFF, FALSE);

  ShellExecute(NULL, "open", Tools.Text.c_str(), Target.c_str(), NULL, SW_SHOWNORMAL) ;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Tools_Dumpbin_ImportsClick(TObject *Sender)
{
  AnsiString Target;
  AnsiString RunDir = DirInfo.BasePath + "/Tools/Dump";
  if (FileOpenDlg->Execute()){Target = "/IMPORTS /OUT:dump_out.txt " + FileOpenDlg->FileName;}

  ShellExecute(NULL, "open", Tools.Dump.c_str(), Target.c_str(), RunDir.c_str(), SW_HIDE);

  Target = RunDir + "/dump_out.txt";
  SleepEx( 0x00000FFF, FALSE);

  ShellExecute(NULL, "open", Tools.Text.c_str(), Target.c_str(), NULL, SW_SHOWNORMAL) ;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Tools_Dumpbin_ExportsClick(TObject *Sender)
{
  AnsiString Target;
  AnsiString RunDir = DirInfo.BasePath + "/Tools/Dump";
  if (FileOpenDlg->Execute()){Target = "/EXPORTS /OUT:dump_out.txt " + FileOpenDlg->FileName;}

  ShellExecute(NULL, "open", Tools.Dump.c_str(), Target.c_str(), RunDir.c_str(), SW_HIDE);

  Target = RunDir + "/dump_out.txt";
  SleepEx( 0x00000FFF, FALSE);

  ShellExecute(NULL, "open", Tools.Text.c_str(), Target.c_str(), NULL, SW_SHOWNORMAL) ;

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Tools_Dumpbin_ArchiveMembersClick(TObject *Sender)
{
  AnsiString Target;
  AnsiString RunDir = DirInfo.BasePath + "/Tools/Dump";
  if (FileOpenDlg->Execute()){Target = "/ARCHIVEMEMBERS /OUT:dump_out.txt " + FileOpenDlg->FileName;}

  ShellExecute(NULL, "open", Tools.Dump.c_str(), Target.c_str(), RunDir.c_str(), SW_HIDE);

  Target = RunDir + "/dump_out.txt";
  SleepEx( 0x00000FFF, FALSE);

  ShellExecute(NULL, "open", Tools.Text.c_str(), Target.c_str(), NULL, SW_SHOWNORMAL) ;

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Tools_Dumpbin_DirectivesClick(TObject *Sender)
{
  AnsiString Target;
  AnsiString RunDir = DirInfo.BasePath + "/Tools/Dump";
  if (FileOpenDlg->Execute()){Target = "/DIRECTIVES /OUT:dump_out.txt " + FileOpenDlg->FileName;}

  ShellExecute(NULL, "open", Tools.Dump.c_str(), Target.c_str(), RunDir.c_str(), SW_HIDE);

  Target = RunDir + "/dump_out.txt";
  SleepEx( 0x00000FFF, FALSE);

  ShellExecute(NULL, "open", Tools.Text.c_str(), Target.c_str(), NULL, SW_SHOWNORMAL) ;

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Tools_Dumpbin_FPOClick(TObject *Sender)
{
  AnsiString Target;
  AnsiString RunDir = DirInfo.BasePath + "/Tools/Dump";
  if (FileOpenDlg->Execute()){Target = "/FPO /OUT:dump_out.txt " + FileOpenDlg->FileName;}

  ShellExecute(NULL, "open", Tools.Dump.c_str(), Target.c_str(), RunDir.c_str(), SW_HIDE);

  Target = RunDir + "/dump_out.txt";
  SleepEx( 0x00000FFF, FALSE);

  ShellExecute(NULL, "open", Tools.Text.c_str(), Target.c_str(), NULL, SW_SHOWNORMAL) ;

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Tools_Dumpbin_HeadersClick(TObject *Sender)
{
  AnsiString Target;
  AnsiString RunDir = DirInfo.BasePath + "/Tools/Dump";
  if (FileOpenDlg->Execute()){Target = "/HEADERS /OUT:dump_out.txt " + FileOpenDlg->FileName;}

  ShellExecute(NULL, "open", Tools.Dump.c_str(), Target.c_str(), RunDir.c_str(), SW_HIDE);

  Target = RunDir + "/dump_out.txt";
  SleepEx( 0x00000FFF, FALSE);

  ShellExecute(NULL, "open", Tools.Text.c_str(), Target.c_str(), NULL, SW_SHOWNORMAL) ;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Tools_Dumpbin_LineNumbersClick(TObject *Sender)
{
  AnsiString Target;
  AnsiString RunDir = DirInfo.BasePath + "/Tools/Dump";
  if (FileOpenDlg->Execute()){Target = "/LINENUMBERS /OUT:dump_out.txt " + FileOpenDlg->FileName;}

  ShellExecute(NULL, "open", Tools.Dump.c_str(), Target.c_str(), RunDir.c_str(), SW_HIDE);

  Target = RunDir + "/dump_out.txt";
  SleepEx( 0x00000FFF, FALSE);

  ShellExecute(NULL, "open", Tools.Text.c_str(), Target.c_str(), NULL, SW_SHOWNORMAL) ;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Tools_Dumpbin_LinkerMembersClick(TObject *Sender)
{
  AnsiString Target;
  AnsiString RunDir = DirInfo.BasePath + "/Tools/Dump";
  if (FileOpenDlg->Execute()){Target = "/LINKERMEMBER /OUT:dump_out.txt " + FileOpenDlg->FileName;}

  ShellExecute(NULL, "open", Tools.Dump.c_str(), Target.c_str(), RunDir.c_str(), SW_HIDE);

  Target = RunDir + "/dump_out.txt";
  SleepEx( 0x00000FFF, FALSE);

  ShellExecute(NULL, "open", Tools.Text.c_str(), Target.c_str(), NULL, SW_SHOWNORMAL) ;

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Tools_Dumpbin_PDataClick(TObject *Sender)
{
  AnsiString Target;
  AnsiString RunDir = DirInfo.BasePath + "/Tools/Dump";
  if (FileOpenDlg->Execute()){Target = "/PDATA /OUT:dump_out.txt " + FileOpenDlg->FileName;}
  ShellExecute(NULL, "open", Tools.Dump.c_str(), Target.c_str(), RunDir.c_str(), SW_HIDE);

  Target = RunDir + "/dump_out.txt";
  SleepEx( 0x00000FFF, FALSE);

  ShellExecute(NULL, "open", Tools.Text.c_str(), Target.c_str(), NULL, SW_SHOWNORMAL) ;

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Tools_Dumpbin_RelocationsClick(TObject *Sender)
{
  AnsiString Target;
  AnsiString RunDir = DirInfo.BasePath + "/Tools/Dump";
  if (FileOpenDlg->Execute()){Target = "/RELOCATIONS /OUT:dump_out.txt " + FileOpenDlg->FileName;}

  ShellExecute(NULL, "open", Tools.Dump.c_str(), Target.c_str(), RunDir.c_str(), SW_HIDE);

  Target = RunDir + "/dump_out.txt";
  SleepEx( 0x00000FFF, FALSE);

  ShellExecute(NULL, "open", Tools.Text.c_str(), Target.c_str(), NULL, SW_SHOWNORMAL) ;

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Tools_Dumpbin_SymbolsClick(TObject *Sender)
{
  AnsiString Target;
  AnsiString RunDir = DirInfo.BasePath + "/Tools/Dump";
  if (FileOpenDlg->Execute()){Target = "/SYMBOLS /OUT:dump_out.txt " + FileOpenDlg->FileName;}

  ShellExecute(NULL, "open", Tools.Dump.c_str(), Target.c_str(), RunDir.c_str(), SW_HIDE);

  Target = RunDir + "/dump_out.txt";
  SleepEx( 0x00000FFF, FALSE);

  ShellExecute(NULL, "open", Tools.Text.c_str(), Target.c_str(), NULL, SW_SHOWNORMAL) ;

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Tools_Dumpbin_DisassemblyClick(TObject *Sender)
{
  AnsiString Target;
  AnsiString RunDir = DirInfo.BasePath + "/Tools/Dump";
  if (FileOpenDlg->Execute()){Target = "/DISASM /OUT:dump_out.txt " + FileOpenDlg->FileName;}

  ShellExecute(NULL, "open", Tools.Dump.c_str(), Target.c_str(), RunDir.c_str(), SW_HIDE);

  Target = RunDir + "/dump_out.txt";
  SleepEx( 0x00000FFF, FALSE);

  ShellExecute(NULL, "open", Tools.Text.c_str(), Target.c_str(), NULL, SW_SHOWNORMAL) ;

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Tools_Dumpbin_RawDataClick(TObject *Sender)
{
  AnsiString Target;
  AnsiString RunDir = DirInfo.BasePath + "/Tools/Dump";
  if (FileOpenDlg->Execute()){Target = "/RAWDATA /OUT:dump_out.txt " + FileOpenDlg->FileName;}

  ShellExecute(NULL, "open", Tools.Dump.c_str(), Target.c_str(), RunDir.c_str(), SW_HIDE);

  Target = RunDir + ";dump_out.txt";
  SleepEx( 0x00000FFF, FALSE);

  ShellExecute(NULL, "open", Tools.Text.c_str(), Target.c_str(), NULL, SW_SHOWNORMAL) ;

}





//****************************************************************************
//******                  Reference Menu                                ******
//****************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void __fastcall TForm1::Help_ASCIITableClick(TObject *Sender)
{
  AnsiString ASCIIHelp = DirInfo.BasePath;
  ASCIIHelp += "/Docs/ascii.hlp";
  ShellExecute(NULL, "open", ASCIIHelp.c_str(), NULL, NULL, SW_SHOWNORMAL);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Help_OpcodesClick(TObject *Sender)
{
 AnsiString OpHelp = DirInfo.BasePath;
 OpHelp += "/Docs/opcodes.hlp";
 ShellExecute(NULL, "open", OpHelp.c_str(), NULL, NULL, SW_SHOWNORMAL);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Help_Win32APIClick(TObject *Sender)
{
 AnsiString APIHelp = DirInfo.BasePath;
 APIHelp += "/Docs/win32api.hlp";
 ShellExecute(NULL, "open", APIHelp.c_str(), NULL, NULL, SW_SHOWNORMAL);

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Help_ContributorsClick(TObject *Sender)
{
 TContributorsFrm* ContributorsFrm = new TContributorsFrm(this);
 try
 {
   ContributorsFrm->ShowModal();
 }
 catch( ... )
 {
   delete ContributorsFrm;
   throw;
 }
 delete ContributorsFrm;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::View_MessageWindowClick(TObject *Sender)
{

  if (Form2->MessageEdit->Visible)
  { // Hide the bottompanel and uncheck the menu item
    Form2->SplitPanel->Visible	= false;
//    Form2->StatusBar1->Parent 	= Form2;
    Form2->MessageEdit->Visible = false;
    View_MessageWindow->Checked = false;
  }
  else  // the panel is not visible, show the panel and check the menu item
  {
//    Form2->StatusBar1->Parent 	= Form2->BottomPanel;
    Form2->MessageEdit->Visible = true;
    Form2->SplitPanel->Visible 	= true;
//    Form2->WinSplit1->TargetControl = Form2->BottomPanel;
//    Form2->WinSplit1->Update();
    View_MessageWindow->Checked = true;
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Options_ConfigureVisAssemblerClick(TObject *Sender)
{
  RegisterNewUser();
}
//---------------------------------------------------------------------------



void __fastcall TForm1::Tools_Debug_DebugClick(TObject *Sender)
{
  TMenuItem* MenuItem = dynamic_cast<TMenuItem*>(Sender);
  if (MenuItem)
  {
    ToolExecute("External Tools Debuggers", MenuItem->Caption);
  }
}

void __fastcall TForm1::Tools_Debug_DisassembleClick(TObject *Sender)
{
  TMenuItem* MenuItem = dynamic_cast<TMenuItem*>(Sender);
  if (MenuItem)
  {
    ToolExecute("External Tools Disassemblers", MenuItem->Caption);
  }
}
//---------------------------------------------------------------------------



int __fastcall TForm1::CreateToolsMenu()
{
  TIniFile* IniFile = new TIniFile(ChangeFileExt(ParamStr(0),".INI"));
  TStringList* Buf = new TStringList;
  try
  {
    IniFile->ReadSection("External Tools Debuggers", Buf);
    for(int i = 0;i < (Buf->Count);i++)
    {
      AnsiString FileName;
	  FileName = IniFile->ReadString("External Tools Debuggers", Buf->Strings[i], "");

	  if(FileName != "" && i < 5)
      {
	  	Form1->Tools_Debug_->Items[i]->Caption = Buf->Strings[i];
	  	Form1->Tools_Debug_->Items[i]->Enabled = true;
	  	Form1->Tools_Debug_->Items[i]->Visible = true;
	  }
    }

    // Debuggers Done, Now the Disassemblers !
    Buf->Clear();

    IniFile->ReadSection("External Tools Disassemblers", Buf);
    for(int i = 0;i < (Buf->Count);i++)
    {
      AnsiString FileName;
	  FileName = IniFile->ReadString("External Tools Disassemblers", Buf->Strings[i], "");

	  if(FileName != "" && i < 5)
      {
	  	Form1->Tools_Disassemble_->Items[i]->Caption = Buf->Strings[i];
	  	Form1->Tools_Disassemble_->Items[i]->Enabled = true;
	  	Form1->Tools_Disassemble_->Items[i]->Visible = true;
	  }
    }
  }
  catch( ... )
  {
    Buf->Free();
    IniFile->Free();
    throw;
  }
Buf->Free();
IniFile->Free();

return 1; // ok success

}







int __fastcall TForm1::InitiateStartSequence()
{

  int retval = ReadIniFiles();

  Form2->PutEditorWindow(Height);
  Form2->Visible = true;

  Form3->PutCodeWindow();
  Form3->Visible = true;

  Form3->LoadInsertables();

return retval;

}


int __fastcall TForm1::ReadIniFiles()
{
  int result = 0; // everything initialized OK !

  if (StartUpInfo()==0 ) {result = 1;}  // Startupinfo resturned false --->
  									  // probably no ini file present !
                                      // or just app configurations corrupt !

  if ( LoadSplitterLocation() == 0) { result = 2;} // splitter ini corrupt ?
  if (LoadButtonsFromIni() == 0)  {result = 3;} // buttons ini corrupt ?

  // now let's create the extra menu items on the tools menu
  if (CreateToolsMenu() == 0) { result = 4;} // couldn't create tools menu mmmmm...

  return result;  // so that everything can be handled at the beginning.
  				  // result = 0 means everything ok
                  // 1 = show config menu
                  // 2 = so nothing yet
                  // 3 = create standard buttons
                  // 4 = show tools menu setup
}

void __fastcall TForm1::FormShow(TObject *Sender)
{
  SetBounds(0,0,Screen->Width, 500);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SplitPanelMouseDown(TObject *Sender,
	TMouseButton Button, TShiftState Shift, int X, int Y)
{
  SplitPanelDragging = true;

}
//---------------------------------------------------------------------------
void __fastcall TForm1::SplitPanelMouseUp(TObject *Sender, TMouseButton Button,
	TShiftState Shift, int X, int Y)
{
  if (SplitPanelDragging)
  {
    SplitPanelDragging = false;
    UpdatePanels();
  }

}
//---------------------------------------------------------------------------
void __fastcall TForm1::SplitPanelMouseMove(TObject *Sender, TShiftState Shift,
	int X, int Y)
{
  if(SplitPanelDragging)
  {
    PalettePanel->Align = alNone;
    SplitPanel->Align = alNone;
    ToolbarPanel->Align = alNone;
    SplitPanel->Left = X + SplitPanel->Left;
  }

}
//---------------------------------------------------------------------------

void __fastcall TForm1::UpdatePanels()
{
  ToolbarPanel->Width = SplitPanel->Left;
  ToolbarPanel->Align = alLeft;

  SplitPanel->Align = alLeft;

  PalettePanel->Align = alClient;
}



void __fastcall TForm1::View_CodeInsertablesClick(TObject *Sender)
{
  bool WindowIsVisible = View_CodeInsertables->Checked;
  View_CodeInsertables->Checked = ! WindowIsVisible;
  Form3->Visible = ! WindowIsVisible;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::File_NewClick(TObject *Sender)
{
  TNewItemsForm* NewItems = new TNewItemsForm(this);
  try
  {
    NewItems->ShowModal();
  }
  catch ( ... )
  {
    delete NewItems;
    throw;
  }
  delete NewItems;

}


void __fastcall TForm1::File_OpenProjectClick(TObject *Sender)
{
FileOpenDlg->Filter = "Project files (project.ini)|project.ini";
FileOpenDlg->InitialDir = DirInfo.ProjectPath;
if (FileOpenDlg->Execute())
  {
    OpenProject(FileOpenDlg->FileName);
  }    
}
//---------------------------------------------------------------------------
void __fastcall TForm1::OpenProject(AnsiString FileName)
{
    TIniFile* IniFile = new TIniFile(FileName);
    ProjectInfo.IniFile = FileName;
    ProjectInfo.Path= IniFile->ReadString( "Settings", "Path", DirInfo.ProjectPath);
    ProjectInfo.Assembler=IniFile->ReadString( "Settings", "Assembler", "TASM");
    ProjectInfo.DefFile=IniFile->ReadString( "Main Modules", "DEF", "");
    ProjectInfo.MakeFile=IniFile->ReadString( "Main Modules", "Makefile", "");
    ProjectInfo.WinMain=IniFile->ReadString( "Main Modules", "WinMain", "");
    ProjectInfo.MainAsm=IniFile->ReadString( "Main Modules", "MainASM", "");
    ProjectInfo.MainData=IniFile->ReadString( "Main Modules", "MainDATA", "");
    ProjectInfo.MainProc=IniFile->ReadString( "Main Modules", "MainPROC", "");
    ProjectInfo.UserProc=IniFile->ReadString( "Main Modules", "UserPROC", "");
    ProjectInfo.RCFile=IniFile->ReadString( "Main Modules", "RC", "");

    IniFile->ReadSection("ASM Modules", ProjectInfo.AsmFiles);
    IniFile->ReadSection("INC Modules", ProjectInfo.IncFiles);
    IniFile->ReadSection("RC Modules", ProjectInfo.RcFiles);
    IniFile->ReadBool("Settings", "IsWin32", TRUE );


    if (ProjectInfo.WinMain != "") Form2->LoadFile( ProjectInfo.WinMain );
    if (ProjectInfo.MainAsm != "")Form2->LoadFile( ProjectInfo.MainAsm );
    if (ProjectInfo.MainProc != "")Form2->LoadFile( ProjectInfo.MainProc );
    if (ProjectInfo.UserProc != "")Form2->LoadFile( ProjectInfo.UserProc );
    if (!ProjectInfo.IsWin32)
    {
     //ProjectMgr->ResourceTab->Enabled = FALSE;
     //ProjectMgr->MessageTab->Enabled = FALSE;
    }
    ProjectMgr->Show();
    ProjectInfo.ProjectOpen = TRUE;
    IniFile->Free();
    AssemblerInfo.Assembler = ProjectInfo.Assembler;
    LoadAssemblerVals();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ProcedureBrowser1Click(TObject *Sender)
{
  AnsiString Target = "";
  ShellExecute(NULL, "open", Tools.Browse.c_str(), Target.c_str(), NULL, SW_SHOWNORMAL) ;

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Search_FileCompare_IDMClick(TObject *Sender)
{
	FileCompareForm->Show();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::File_NewProjectClick(TObject *Sender)
{
   AsmWiz->Show();
    //AnsiString WizardFileName;
   //Set up pointer to Project Info Structure
   //PROJSTRUCT *WizPtr = &Form1->ProjectInfo;
   //int (PASCAL FAR * pfnWizMain)(PROJSTRUCT FAR *);
   //Set up DLL
   //AnsiString DLLName = Form1->DirInfo.BasePath + "\\Wizards\\" + WizardFileName;
   //Load DLL, ya ya
   //HINSTANCE hWizDll =  LoadLibrary( DLLName.c_str() );
   //if (!hWizDll) Form2->MessageEdit->Lines->Append("Library Not Found!");
   //else {
       //Goodgood run routine
      //(FARPROC) pfnWizMain = GetProcAddress( hWizDll, "VsmWizard");
      //if (!pfnWizMain) Form2->MessageEdit->Lines->Append("Library Function Not found!");
      //else {
           //(*pfnWizMain)(WizPtr);
      //}
      //(FARPROC) pfnWizMain = GetProcAddress( hWizDll, "VsmStatus");
      //if (!pfnWizMain) Form2->MessageEdit->Lines->Append("Library Function Not found!");
      //else {
           //(*pfnWizMain)(WizPtr);
      //}
   //}
   //ByeBye  Library
   //FreeLibrary( hWizDll);
   //Run IDE junk to load Project
   //OpenProject(ProjectInfo.IniFile);
   ProjectInfo.ProjectOpen = TRUE;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SpeedButton1Click(TObject *Sender)
{
    AnsiString SCRPath = DirInfo.ModulePath + "/Dialog.scr";
    InsertAsmComponent( SCRPath.c_str(), "FileOpenDialog", "Win32");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::InsertAsmComponent(char* SCRPath, AnsiString CodeSCR, char* SCROwner)
{
    TSourceCode *ComponentCode;
    TCodeElement *CodeElement;
    TStringList *Buffer;
    Buffer= new TStringList;
    int i;
    ComponentCode=new TSourceCode( SCRPath , SCROwner );
    if (!ComponentCode) Form2->MessageEdit->Lines->Add("FileNot Found!");
    CodeElement=ComponentCode->Block(CodeSCR.c_str() );
    if ( CodeElement)
    {
        if (ProjectInfo.ProjectOpen){
           if(CodeElement->dataLines()>0){
            for (i=1;i<=CodeElement->dataLines();i++)
            {
               ProjectMgr->GlobalDataEdit->Lines->Append( CodeElement->Data(i)->Text() );
               ProjectMgr->Button8Click(this);
            }
           } 
           TStringList *Buffer;
           Buffer= new TStringList;
           Buffer->LoadFromFile(ProjectInfo.UserProc);
           for (i=1;i<=CodeElement->numLines();i++)
             {
                Buffer->Add(CodeElement->Line(i)->Text() );
             }
           Buffer->SaveToFile(ProjectInfo.UserProc);
           Buffer->Free();
        }
        else{
           if (CodeElement->dataLines() > 0){
            int Index =  Form2->CurrentRichEdit()->Lines->IndexOf(".code");
            if (Index == -1) Index =  Form2->CurrentRichEdit()->Lines->IndexOf(".CODE");
            if (Index == -1) Index =  Form2->CurrentRichEdit()->Lines->IndexOf(".Code");
            if (Index == -1) {
              Index =  Form2->CurrentRichEdit()->Lines->Count;
              Form2->CurrentRichEdit()->Lines->Insert(Index, ".code");
            }
            int Index2 =  Form2->CurrentRichEdit()->Lines->IndexOf(".data");
            if (Index2 == -1) Index2 =  Form2->CurrentRichEdit()->Lines->IndexOf(".DATA");
            if (Index2 == -1) Index2 =  Form2->CurrentRichEdit()->Lines->IndexOf(".Data");
            if (Index2 == -1) {
              Form2->CurrentRichEdit()->Lines->Insert(Index, ".data");
              Index++;
            }
            for (i=1;i<=CodeElement->dataLines();i++)
            {
               Form2->CurrentRichEdit()->Lines->Insert( Index + (i-1), CodeElement->Data(i)->Text() );
            }
           } 
           for (i=1;i<=CodeElement->numLines();i++){
              Form2->CurrentRichEdit()->Lines->Append(CodeElement->Line(i)->Text() );
            }
        }
    }
    else
    {
       Form2->CurrentRichEdit()->SelText = "Error! Functions Not Found!";
       Form2->CurrentRichEdit()->SelText= "\n";
       char *Buffer;
       Buffer = ComponentCode->FunctionList();
       Form2->CurrentRichEdit()->SelText= Buffer;
    }
    delete (ComponentCode);
}




void __fastcall TForm1::View_ProjMan_IDMClick(TObject *Sender)
{
    ProjectMgr->Show();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::LoadAssemblerVals()
{
//
TIniFile* IniFile2 = new TIniFile( DirInfo.BasePath + "\compilers.ini");
AssemblerInfo.CompileString = IniFile2->ReadString( AssemblerInfo.Assembler, "Compile", "");
AssemblerInfo.CompilerError = IniFile2->ReadString( AssemblerInfo.Assembler, "Compile", "");
AssemblerInfo.LinkString = IniFile2->ReadString( AssemblerInfo.Assembler, "Compile", "");
AssemblerInfo.LinkerError = IniFile2->ReadString( AssemblerInfo.Assembler, "Compile", "");
AssemblerInfo.CompileString = IniFile2->ReadString( AssemblerInfo.Assembler, "Compile", "");

IniFile2->Free();
}
void __fastcall TForm1::File_CloseProject_IDMClick(TObject *Sender)
{
  ProjectMgr->Close();
  File_CloseAllClick(this);
  ProjectInfo.ProjectOpen = FALSE;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SpeedButton2Click(TObject *Sender)
{
    AnsiString SCRPath = DirInfo.ModulePath + "/Dialog.scr";
    InsertAsmComponent( SCRPath.c_str(), "PrintDialog", "Win32");
}
//---------------------------------------------------------------------------
